#include <allegro.h>

#include "main.h"
#include "chat.h"
#include "gfx.h"
#include "title.h"
#include "game.h"

FONT *font64;

GFX *gfx;
SAMPLE *bop;
SAMPLE *ahahaa;
SAMPLE *move;
SAMPLE *poof;

PALETTE pal;

volatile unsigned int ticks = 0;

void timer(void)
{
	ticks++;
}
END_OF_FUNCTION(timer)

volatile int close_button_pressed = FALSE;
void close_button_handler(void)
{
	close_button_pressed = TRUE;
}
END_OF_FUNCTION(close_button_handler)


/* network communication */
ENetPeer *peer;
ENetHost *client;

int main(void)
{
//	BITMAP *buffer;
	RGB rgb;
	int card, w, h;
	int menu_choice;
	
    if (enet_initialize () != 0) return EXIT_FAILURE;
 
    atexit (enet_deinitialize);


	set_config_file("config.ini");
	allegro_init();
	install_keyboard();
	install_timer();
	install_sound(DIGI_AUTODETECT, MIDI_NONE, NULL);

	bop = load_wav("data/bop.wav");
	move = load_wav("data/move.wav");
	ahahaa = load_wav("data/ahahaa.wav");
	poof = load_wav("data/poof.wav");

	LOCK_VARIABLE(ticks);
	LOCK_FUNCTION(timer);
	install_int_ex(timer, BPS_TO_TIMER(60));
	
	LOCK_FUNCTION(close_button_handler);
	set_close_button_callback(close_button_handler);

	
	set_window_title("Rebels and Lords");

	set_color_depth(8);

	card = get_config_int("gfx", "card", 1337);
	w = get_config_int("gfx", "width", 0);
	h = get_config_int("gfx", "height", 0);
	
	install_mouse();
	show_mouse(screen);
	while (!w || set_gfx_mode(card, w,h, 0,0))
	{
		set_gfx_mode(GFX_SAFE, 320,240, 0,0);
		if (!gfx_mode_select(&card, &w, &h)) exit(1);
	}
	remove_mouse();

	if (set_display_switch_mode(SWITCH_BACKGROUND))
		set_display_switch_mode(SWITCH_BACKAMNESIA);


	set_config_int("gfx", "card", card);
	set_config_int("gfx", "width", w);
	set_config_int("gfx", "height", h);
	
	srand(time(0));

	gfx = gfx_create_ex(GFX_DOUBLE_BUFFER, 320,200, 8);

	if (!(font64 = load_font("data/c64font.pcx", NULL, NULL)))
	{
		allegro_message("Unable to open data/c64font.pcx\n");
		exit(1);
	}
	
	game_init();
	while ((menu_choice = title_show()) != 2)
	{		
		clear(screen);
		/* background */
		rgb.r = 0x44/4; rgb.g = 0xcc/4; rgb.b = 0x44/4; set_color(0, &rgb);

		/* plains, trees, rocks */
		rgb.r = 0xff/4; rgb.g = 0xff/4; rgb.b = 0x00/4; set_color(1, &rgb);
		rgb.r = 0x40/4; rgb.g = 0x40/4; rgb.b = 0x40/4; set_color(2, &rgb);
		rgb.r = 0x66/4; rgb.g = 0x33/4; rgb.b = 0x00/4; set_color(3, &rgb);

		/* player colors */
		rgb.r = 0x00/4; rgb.g = 0x00/4; rgb.b = 0x00/4; set_color(4, &rgb);
		rgb.r = 0x99/4; rgb.g = 0x00/4; rgb.b = 0x00/4; set_color(5, &rgb);
		rgb.r = 0xff/4; rgb.g = 0xff/4; rgb.b = 0x00/4; set_color(6, &rgb);
		rgb.r = 0x00/4; rgb.g = 0xff/4; rgb.b = 0xcc/4; set_color(7, &rgb);
		rgb.r = 0xff/4; rgb.g = 0xff/4; rgb.b = 0xff/4; set_color(8, &rgb);

		/* cursor */
		rgb.r = 0x11/4; rgb.g = 0x00/4; rgb.b = 0x99/4; set_color(9, &rgb);

		/* standards colors */
		rgb.r = 0xff/4; rgb.g = 0x00/4; rgb.b = 0x00/4; set_color(13, &rgb);
		rgb.r = 0xff/4; rgb.g = 0xff/4; rgb.b = 0xff/4; set_color(14, &rgb);
		rgb.r = 0x00/4; rgb.g = 0x00/4; rgb.b = 0x00/4; set_color(15, &rgb);

		if (menu_choice == 0)
		{
			lost_connection = FALSE;
			game_begin();
			while (!game_take_turns())
			{			
				game_move();
			}

			game_end();
		}
		else if (menu_choice == 1)
		{
			int mode = chat_enter();

			if (mode > 0)
			{
				/* Online Game */
				lost_connection = FALSE;

				if (mode == 1)
				{
					/* master */
					game_begin_network((rand()%20) + 10,(rand() % 2) + 2);
					while (!lost_connection && !game_take_turns())
						game_move();
				}
				else
				{
					/* slave */				
					game_begin_client();
					while (!lost_connection && !game_take_turns())
						game_watch_move();
				}
				
				game_end();

				if (lost_connection)
				{
					BITMAP *bmp = gfx_frame_start(gfx);
					textprintf_ex(bmp, font64, 0,0, 15,-1, "LOST CONNECTION");
					gfx_frame_end(gfx);
				}
			}
		}
	}

	game_shutdown();

	
	if (bop) destroy_sample(bop);
	if (move) destroy_sample(move);
	if (ahahaa) destroy_sample(ahahaa);
	if (poof) destroy_sample(poof);

	gfx_destroy(gfx);

	return 0;
}
END_OF_MAIN()
